<?php
/**
 * Displays header site navbar
 */
?>
<!-- <div class="site-headbar">
	<p>Mock header, user can add custom html here</p>
</div> -->
<div class="header-container">
	<div class="site-navbar">
		<div class="site-brand">
			<?php if ( has_nav_menu( 'primary' ) ) : ?>
			<label for="menu-state" id="icon-menu"><i class="icon-nav"></i></label>
			<?php endif; ?>
			<?php if ( has_custom_logo() ) { ?>
				<div class="site-logo"><?php the_custom_logo(); ?></div>
			<?php } else { ?>
			    <div class="site-logo"><svg width="40" height="36" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="none" stroke-width="1.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"> <g class="loading-bounce"> <line style="--n: 0" x1="3" y1="12" x2="3" y2="12"></line> <line style="--n: 1" x1="6" y1="10" x2="6" y2="14"></line> <line style="--n: 2" x1="9" y1="8" x2="9" y2="16"></line> <line style="--n: 3" x1="12" y1="4" x2="12" y2="20"></line> <line style="--n: 4" x1="15" y1="9" x2="15" y2="15"></line> <line style="--n: 5" x1="18" y1="7" x2="18" y2="17"></line> <line style="--n: 6" x1="21" y1="11" x2="21" y2="13"></line> </g> </svg></div>
			<? } ?>
			<?php $site_title = get_bloginfo( 'name' ); ?>
			<?php if ( ! empty( $site_title ) ) : ?>
				<?php if ( is_front_page() && is_home() ) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html($site_title); ?></a></h1>
				<?php else : ?>
					<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html($site_title); ?></a></p>
				<?php endif; ?>
			<?php endif; ?>
		</div>
		<div class="flex"></div>
		<form class="search-form" method="get" action="<?php echo esc_url(home_url()); ?>">
			<input type="search" placeholder="<?php esc_attr_e('Search...','waveme'); ?>" value="" name="s" data-toggle="dropdown">
			<label for="search-state" id="icon-search">
				<i class="icon-search"><i></i></i>
			</label>
			<div class="dropdown-menu"></div>
		</form>
		<div class="flex"></div>
		<?php if ( has_nav_menu( 'secondary' ) ) : ?>
			<nav id="secondary-menu" class="secondary-menu">
				<label id="icon-nav">• • •</label>
				<?php
				wp_nav_menu(
					array(
						'theme_location' => 'secondary',
						'menu_class'     => 'nav',
						'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					)
				);
				?>
			</nav>
		<?php endif; ?>

		<?php if ( !is_user_logged_in() && has_nav_menu( 'before_login' ) ) : ?>
			<nav class="menu-before-login">
				<?php
				wp_nav_menu(
					array(
						'theme_location' => 'before_login',
						'menu_class'     => 'nav',
						'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					)
				);
				?>
			</nav>
		<?php endif; ?>
		<?php if ( is_user_logged_in() && has_nav_menu( 'after_login' ) ) : ?>
			<nav class="menu-after-login">
				<?php
				do_action('menu_after_login_before');
				wp_nav_menu(
					array(
						'theme_location' => 'after_login',
						'menu_class'     => 'nav',
						'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					)
				);
				do_action('menu_after_login_after');
				?>
			</nav>
		<?php endif; ?>
	</div>
</div>
